<?php
$page_title = "Profile Settings - HeatGuard";
$additional_css = ['assets/css/profile.css'];
$additional_js = ['assets/js/profile.js'];

$user = [
    'name' => 'Officer Jerome Buntalidad',
    'role' => 'Traffic Enforcer',
    'department' => 'Bacolod TMU',
    'badge' => 'TMU-2024-001',
    'status' => 'on_duty',
    'email' => 'jerome.buntalidad@bacolodtmu.gov.ph',
    'phone' => '+63 912 345 6789',
    'address' => 'Bacolod City, Negros Occidental',
    'joined_date' => '2024-01-15',
    'last_login' => '2024-09-07 08:30:00',
    'profile_completion' => 85
];

$notification_settings = [
    'heat_alerts' => true,
    'schedule_reminders' => true,
    'emergency_notifications' => true,
    'system_updates' => false,
    'email_notifications' => true,
    'sms_notifications' => true,
    'break_reminders' => true
];

$activity_log = [
    [
        'action' => 'Profile Updated',
        'timestamp' => '2024-09-06 14:30:00',
        'details' => 'Changed phone number'
    ],
    [
        'action' => 'Password Changed',
        'timestamp' => '2024-09-05 09:15:00',
        'details' => 'Security update completed'
    ],
    [
        'action' => 'Emergency Contact Added',
        'timestamp' => '2024-09-03 16:45:00',
        'details' => 'Added spouse as emergency contact'
    ]
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link rel="stylesheet" href="assets/css/profile.css">
    <link rel="stylesheet" href="assets/css/main-footer.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <span class="logo-icon">🚦</span>
                    <span>HeatGuard</span>
                </div>
            </div>
            
            <nav class="sidebar-nav">
                <div class="nav-section">
                    <div class="nav-section-title">Main Dashboard</div>
                    <div class="nav-item">
                        <a href="dashboard.php" class="nav-link">
                            <i class="nav-icon fas fa-tachometer-alt"></i>
                            <span>Overview</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Core Modules</div>
                    <div class="nav-item">
                        <a href="user-management.php" class="nav-link">
                            <i class="nav-icon fas fa-users"></i>
                            <span>User Management</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="heat-monitoring.php" class="nav-link">
                            <i class="nav-icon fas fa-thermometer-half"></i>
                            <span>Heat Index Monitoring</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="schedule-management.php" class="nav-link">
                            <i class="nav-icon fas fa-calendar-alt"></i>
                            <span>Schedule Management</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="safety-guidelines.php" class="nav-link">
                            <i class="nav-icon fas fa-shield-alt"></i>
                            <span>Safety Guidelines</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="emergency-response.php" class="nav-link">
                            <i class="nav-icon fas fa-exclamation-triangle"></i>
                            <span>Emergency Response</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="reporting-system.php" class="nav-link">
                            <i class="nav-icon fas fa-chart-bar"></i>
                            <span>Automated Reports</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Quick Actions</div>
                    <div class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-ambulance"></i>
                            <span>Emergency Alert</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-file-download"></i>
                            <span>Export Reports</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Account</div>
                    <div class="nav-item">
                        <a href="profile.php" class="nav-link active">
                            <i class="nav-icon fas fa-user"></i>
                            <span>Profile Settings</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="index.php" class="nav-link">
                            <i class="nav-icon fas fa-sign-out-alt"></i>
                            <span>Logout</span>
                        </a>
                    </div>
                </div>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Top Bar -->
            <header class="top-bar">
                <div class="top-bar-left">
                    <button class="menu-toggle" id="menuToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1 class="page-title">Profile Settings</h1>
                </div>
                
                <div class="top-bar-right">
                    <div class="status-indicator <?php echo $user['status'] === 'on_duty' ? 'status-online' : 'status-offline'; ?>">
                        <i class="fas fa-circle"></i>
                        <?php echo $user['status'] === 'on_duty' ? 'On Duty' : 'Off Duty'; ?>
                    </div>
                    
                    <div class="user-menu">
                        <div class="user-avatar">
                            <?php echo strtoupper(substr($user['name'], 8, 1)) . strtoupper(substr($user['name'], 13, 1)); ?>
                        </div>
                        <div class="user-info">
                            <h4><?php echo explode(' ', $user['name'])[1] . ' ' . explode(' ', $user['name'])[2]; ?></h4>
                            <p><?php echo $user['role']; ?></p>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Profile Content -->
            <div class="profile-content">
                <!-- Profile Header -->
                <div class="profile-header">
                    <div class="profile-banner">
                        <div class="profile-avatar-section">
                            <div class="profile-avatar-large">
                                <?php echo strtoupper(substr($user['name'], 8, 1)) . strtoupper(substr($user['name'], 13, 1)); ?>
                            </div>
                            <button class="avatar-upload-btn">
                                <i class="fas fa-camera"></i>
                                Change Photo
                            </button>
                        </div>
                        <div class="profile-info">
                            <h2><?php echo $user['name']; ?></h2>
                            <p class="profile-role"><?php echo $user['role']; ?> • <?php echo $user['department']; ?></p>
                            <p class="profile-badge">Badge: <?php echo $user['badge']; ?></p>
                            <div class="profile-completion">
                                <span>Profile Completion: <?php echo $user['profile_completion']; ?>%</span>
                                <div class="progress-bar">
                                    <div class="progress-fill" style="width: <?php echo $user['profile_completion']; ?>%"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Profile Tabs -->
                <div class="profile-tabs">
                    <div class="tab-nav">
                        <button class="tab-btn active" data-tab="personal">
                            <i class="fas fa-user"></i>
                            Personal Information
                        </button>
                        <button class="tab-btn" data-tab="security">
                            <i class="fas fa-shield-alt"></i>
                            Security Settings
                        </button>
                        <button class="tab-btn" data-tab="notifications">
                            <i class="fas fa-bell"></i>
                            Notifications
                        </button>
                        <button class="tab-btn" data-tab="activity">
                            <i class="fas fa-history"></i>
                            Activity Log
                        </button>
                    </div>

                    <!-- Personal Information Tab -->
                    <div class="tab-content active" id="personal">
                        <div class="settings-grid">
                            <div class="settings-card">
                                <h3><i class="fas fa-user-edit"></i> Basic Information</h3>
                                <form class="settings-form" id="personalForm">
                                    <div class="form-row">
                                        <div class="form-group">
                                            <label for="fullName">Full Name</label>
                                            <input type="text" id="fullName" name="fullName" value="<?php echo $user['name']; ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="badge">Badge Number</label>
                                            <input type="text" id="badge" name="badge" value="<?php echo $user['badge']; ?>" readonly>
                                        </div>
                                    </div>
                                    
                                    <div class="form-row">
                                        <div class="form-group">
                                            <label for="email">Email Address</label>
                                            <input type="email" id="email" name="email" value="<?php echo $user['email']; ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="phone">Phone Number</label>
                                            <input type="tel" id="phone" name="phone" value="<?php echo $user['phone']; ?>">
                                        </div>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="address">Address</label>
                                        <textarea id="address" name="address" rows="3"><?php echo $user['address']; ?></textarea>
                                    </div>
                                    
                                    <div class="form-row">
                                        <div class="form-group">
                                            <label for="department">Department</label>
                                            <select id="department" name="department">
                                                <option value="Bacolod TMU" <?php echo $user['department'] === 'Bacolod TMU' ? 'selected' : ''; ?>>Bacolod TMU</option>
                                                <option value="Traffic Division">Traffic Division</option>
                                                <option value="Safety Unit">Safety Unit</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="role">Role</label>
                                            <select id="role" name="role">
                                                <option value="Traffic Enforcer" <?php echo $user['role'] === 'Traffic Enforcer' ? 'selected' : ''; ?>>Traffic Enforcer</option>
                                                <option value="Health Officer">Health Officer</option>
                                                <option value="Admin">Admin</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save"></i>
                                        Update Information
                                    </button>
                                </form>
                            </div>

                            <div class="settings-card">
                                <h3><i class="fas fa-phone-alt"></i> Emergency Contacts</h3>
                                <div class="emergency-contacts">
                                    <div class="contact-item">
                                        <div class="contact-info">
                                            <h4>Maria Buntalidad</h4>
                                            <p>Spouse • +63 912 345 6788</p>
                                        </div>
                                        <button class="btn btn-sm btn-outline">Edit</button>
                                    </div>
                                    <div class="contact-item">
                                        <div class="contact-info">
                                            <h4>Dr. Juan Santos</h4>
                                            <p>Family Doctor • +63 912 345 6787</p>
                                        </div>
                                        <button class="btn btn-sm btn-outline">Edit</button>
                                    </div>
                                    <button class="btn btn-outline add-contact-btn">
                                        <i class="fas fa-plus"></i>
                                        Add Emergency Contact
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Security Settings Tab -->
                    <div class="tab-content" id="security">
                        <div class="settings-grid">
                            <div class="settings-card">
                                <h3><i class="fas fa-lock"></i> Password & Security</h3>
                                <form class="settings-form" id="securityForm">
                                    <div class="form-group">
                                        <label for="currentPassword">Current Password</label>
                                        <input type="password" id="currentPassword" name="currentPassword" placeholder="Enter current password">
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="newPassword">New Password</label>
                                        <input type="password" id="newPassword" name="newPassword" placeholder="Enter new password">
                                        <div class="password-strength">
                                            <div class="strength-bar">
                                                <div class="strength-fill"></div>
                                            </div>
                                            <span class="strength-text">Password strength: <span id="strengthLevel">-</span></span>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="confirmPassword">Confirm New Password</label>
                                        <input type="password" id="confirmPassword" name="confirmPassword" placeholder="Confirm new password">
                                    </div>
                                    
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-key"></i>
                                        Change Password
                                    </button>
                                </form>
                            </div>

                            <div class="settings-card">
                                <h3><i class="fas fa-mobile-alt"></i> Two-Factor Authentication</h3>
                                <div class="two-factor-section">
                                    <div class="two-factor-status">
                                        <div class="status-indicator status-enabled">
                                            <i class="fas fa-check-circle"></i>
                                            <span>2FA is currently disabled</span>
                                        </div>
                                        <button class="btn btn-primary">Enable 2FA</button>
                                    </div>
                                    <p class="two-factor-description">
                                        Add an extra layer of security to your account by enabling two-factor authentication.
                                        You'll need your phone to sign in.
                                    </p>
                                </div>
                            </div>

                            <div class="settings-card">
                                <h3><i class="fas fa-history"></i> Login Sessions</h3>
                                <div class="login-sessions">
                                    <div class="session-item current-session">
                                        <div class="session-info">
                                            <h4>Current Session</h4>
                                            <p>Windows • Chrome • Bacolod City</p>
                                            <span class="session-time">Active now</span>
                                        </div>
                                        <span class="session-badge">Current</span>
                                    </div>
                                    <div class="session-item">
                                        <div class="session-info">
                                            <h4>Mobile Session</h4>
                                            <p>Android • Chrome Mobile • Bacolod City</p>
                                            <span class="session-time">2 hours ago</span>
                                        </div>
                                        <button class="btn btn-sm btn-danger">Revoke</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Notifications Tab -->
                    <div class="tab-content" id="notifications">
                        <div class="settings-card">
                            <h3><i class="fas fa-bell"></i> Notification Preferences</h3>
                            <form class="settings-form" id="notificationsForm">
                                <div class="notification-categories">
                                    <div class="notification-category">
                                        <h4>Heat Alerts</h4>
                                        <div class="notification-options">
                                            <div class="notification-option">
                                                <div class="option-info">
                                                    <h5>Heat Index Warnings</h5>
                                                    <p>Get notified when heat index reaches dangerous levels</p>
                                                </div>
                                                <label class="toggle">
                                                    <input type="checkbox" <?php echo $notification_settings['heat_alerts'] ? 'checked' : ''; ?>>
                                                    <span class="slider"></span>
                                                </label>
                                            </div>
                                            <div class="notification-option">
                                                <div class="option-info">
                                                    <h5>Break Reminders</h5>
                                                    <p>Automatic reminders to take breaks during high heat</p>
                                                </div>
                                                <label class="toggle">
                                                    <input type="checkbox" <?php echo $notification_settings['break_reminders'] ? 'checked' : ''; ?>>
                                                    <span class="slider"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="notification-category">
                                        <h4>Schedule & Tasks</h4>
                                        <div class="notification-options">
                                            <div class="notification-option">
                                                <div class="option-info">
                                                    <h5>Schedule Reminders</h5>
                                                    <p>Get notified about upcoming shifts and schedule changes</p>
                                                </div>
                                                <label class="toggle">
                                                    <input type="checkbox" <?php echo $notification_settings['schedule_reminders'] ? 'checked' : ''; ?>>
                                                    <span class="slider"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="notification-category">
                                        <h4>Emergency & Safety</h4>
                                        <div class="notification-options">
                                            <div class="notification-option">
                                                <div class="option-info">
                                                    <h5>Emergency Notifications</h5>
                                                    <p>Critical alerts about emergency situations</p>
                                                </div>
                                                <label class="toggle">
                                                    <input type="checkbox" <?php echo $notification_settings['emergency_notifications'] ? 'checked' : ''; ?>>
                                                    <span class="slider"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="notification-category">
                                        <h4>System Updates</h4>
                                        <div class="notification-options">
                                            <div class="notification-option">
                                                <div class="option-info">
                                                    <h5>System Updates</h5>
                                                    <p>Information about system updates and new features</p>
                                                </div>
                                                <label class="toggle">
                                                    <input type="checkbox" <?php echo $notification_settings['system_updates'] ? 'checked' : ''; ?>>
                                                    <span class="slider"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="delivery-methods">
                                    <h4>Delivery Methods</h4>
                                    <div class="method-options">
                                        <div class="method-option">
                                            <div class="method-info">
                                                <i class="fas fa-envelope"></i>
                                                <span>Email Notifications</span>
                                            </div>
                                            <label class="toggle">
                                                <input type="checkbox" <?php echo $notification_settings['email_notifications'] ? 'checked' : ''; ?>>
                                                <span class="slider"></span>
                                            </label>
                                        </div>
                                        <div class="method-option">
                                            <div class="method-info">
                                                <i class="fas fa-sms"></i>
                                                <span>SMS Notifications</span>
                                            </div>
                                            <label class="toggle">
                                                <input type="checkbox" <?php echo $notification_settings['sms_notifications'] ? 'checked' : ''; ?>>
                                                <span class="slider"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i>
                                    Save Preferences
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Activity Log Tab -->
                    <div class="tab-content" id="activity">
                        <div class="settings-card">
                            <h3><i class="fas fa-history"></i> Recent Activity</h3>
                            <div class="activity-log">
                                <?php foreach ($activity_log as $activity): ?>
                                <div class="activity-item">
                                    <div class="activity-icon">
                                        <i class="fas fa-<?php echo getActivityIcon($activity['action']); ?>"></i>
                                    </div>
                                    <div class="activity-details">
                                        <h4><?php echo $activity['action']; ?></h4>
                                        <p><?php echo $activity['details']; ?></p>
                                        <span class="activity-time"><?php echo date('M j, Y g:i A', strtotime($activity['timestamp'])); ?></span>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                            
                            <div class="account-stats">
                                <h4>Account Statistics</h4>
                                <div class="stats-grid">
                                    <div class="stat-item">
                                        <div class="stat-value"><?php echo date('M j, Y', strtotime($user['joined_date'])); ?></div>
                                        <div class="stat-label">Member Since</div>
                                    </div>
                                    <div class="stat-item">
                                        <div class="stat-value"><?php echo date('M j, Y g:i A', strtotime($user['last_login'])); ?></div>
                                        <div class="stat-label">Last Login</div>
                                    </div>
                                    <div class="stat-item">
                                        <div class="stat-value"><?php echo $user['profile_completion']; ?>%</div>
                                        <div class="stat-label">Profile Complete</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
    <script src="assets/js/profile.js"></script>
     <?php include 'main-footer.php'; ?>
</body>
</html>
<?php
function getActivityIcon($action) {
    switch ($action) {
        case 'Profile Updated': return 'user-edit';
        case 'Password Changed': return 'key';
        case 'Emergency Contact Added': return 'user-plus';
        default: return 'info-circle';
    }
}
?>
