<?php
$page_title = "Safety Guidelines - HeatGuard";
$additional_css = ['assets/css/safety-guidelines.css'];
$additional_js = ['assets/js/safety-guidelines.js'];

$user = [
    'name' => 'Officer Jerome Buntalidad',
    'role' => 'Traffic Enforcer',
    'department' => 'Bacolod TMU',
    'badge' => 'TMU-2024-001',
    'status' => 'on_duty'
];

$current_heat_index = 42;
$heat_level = 'DANGER';

$safety_guidelines = [
    'SAFE' => [
        'level' => 'Safe',
        'range' => '27°C - 32°C',
        'color' => 'safe',
        'icon' => 'fa-check-circle',
        'guidelines' => [
            'Regular hydration every 30 minutes',
            'Standard work schedule applies',
            'Light-colored, breathable clothing recommended',
            'Monitor for early signs of heat stress',
            'Take shade breaks when possible'
        ],
        'precautions' => [
            'Drink water regularly',
            'Wear sunscreen SPF 30+',
            'Use protective gear as needed'
        ]
    ],
    'CAUTION' => [
        'level' => 'Caution',
        'range' => '32°C - 41°C',
        'color' => 'caution',
        'icon' => 'fa-exclamation-triangle',
        'guidelines' => [
            'Increase hydration frequency to every 15-20 minutes',
            'Take 15-minute shade breaks every hour',
            'Monitor officers closely for heat exhaustion signs',
            'Reduce physical activity intensity',
            'Ensure proper ventilation in work areas'
        ],
        'precautions' => [
            'Mandatory water breaks every 15 minutes',
            'Rotate personnel every 2 hours',
            'Keep first aid supplies readily available',
            'Have cooling towels on standby'
        ]
    ],
    'DANGER' => [
        'level' => 'Danger',
        'range' => '41°C - 54°C',
        'color' => 'danger',
        'icon' => 'fa-exclamation-circle',
        'guidelines' => [
            'Mandatory 10-minute breaks every 30 minutes in shade',
            'Continuous hydration every 10-15 minutes',
            'Rotate officers every hour',
            'Restrict outdoor activities to essential only',
            'Have cooling stations readily available'
        ],
        'precautions' => [
            'Emergency medical support on standby',
            'Immediate shade/cooling access required',
            'Monitor vital signs regularly',
            'Consider indoor assignments when possible'
        ]
    ],
    'EXTREME' => [
        'level' => 'Extreme Danger',
        'range' => '54°C and above',
        'color' => 'extreme',
        'icon' => 'fa-skull-crossbones',
        'guidelines' => [
            'SUSPEND all non-essential outdoor activities',
            'Maximum 30 minutes outdoor exposure',
            'Mandatory 15-minute cooling breaks',
            'Emergency medical team on site',
            'Consider postponing traffic operations'
        ],
        'precautions' => [
            'Medical personnel required on duty',
            'Air-conditioned rest areas mandatory',
            'Ice packs and cooling vests available',
            'Immediate evacuation plan in place'
        ]
    ]
];

$emergency_contacts = [
    ['name' => 'Emergency Hotline', 'number' => '911', 'type' => 'emergency'],
    ['name' => 'Bacolod Medical Center', 'number' => '(034) 433-6471', 'type' => 'hospital'],
    ['name' => 'TMU Supervisor', 'number' => '(034) 445-5555', 'type' => 'supervisor'],
    ['name' => 'Health Department', 'number' => '(034) 441-1234', 'type' => 'health']
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link rel="stylesheet" href="assets/css/dashboard.css">
    <link rel="stylesheet" href="assets/css/safety-guidelines.css">
    <link rel="stylesheet" href="assets/css/main-footer.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <span class="logo-icon">🚦</span>
                    <span>HeatGuard</span>
                </div>
            </div>
            
            <nav class="sidebar-nav">
                <div class="nav-section">
                    <div class="nav-section-title">Main Dashboard</div>
                    <div class="nav-item">
                        <a href="dashboard.php" class="nav-link">
                            <i class="nav-icon fas fa-tachometer-alt"></i>
                            <span>Overview</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Core Modules</div>
                    <div class="nav-item">
                        <a href="user-management.php" class="nav-link">
                            <i class="nav-icon fas fa-users"></i>
                            <span>User Management</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="heat-monitoring.php" class="nav-link">
                            <i class="nav-icon fas fa-thermometer-half"></i>
                            <span>Heat Index Monitoring</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="schedule-management.php" class="nav-link">
                            <i class="nav-icon fas fa-calendar-alt"></i>
                            <span>Schedule Management</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="safety-guidelines.php" class="nav-link active">
                            <i class="nav-icon fas fa-shield-alt"></i>
                            <span>Safety Guidelines</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="emergency-response.php" class="nav-link">
                            <i class="nav-icon fas fa-exclamation-triangle"></i>
                            <span>Emergency Response</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="reporting-system.php" class="nav-link">
                            <i class="nav-icon fas fa-chart-bar"></i>
                            <span>Automated Reports</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Quick Actions</div>
                    <div class="nav-item">
                        <a href="emergency-response.php" class="nav-link">
                            <i class="nav-icon fas fa-ambulance"></i>
                            <span>Emergency Alert</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="#" class="nav-link" onclick="downloadGuidelines()">
                            <i class="nav-icon fas fa-file-download"></i>
                            <span>Download Guidelines</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Account</div>
                    <div class="nav-item">
                        <a href="profile.php" class="nav-link">
                            <i class="nav-icon fas fa-user"></i>
                            <span>Profile Settings</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="index.php" class="nav-link">
                            <i class="nav-icon fas fa-sign-out-alt"></i>
                            <span>Logout</span>
                        </a>
                    </div>
                </div>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Top Bar -->
            <header class="top-bar">
                <div class="top-bar-left">
                    <button class="menu-toggle" id="menuToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1 class="page-title">Safety Guidelines & Protocols</h1>
                </div>
                
                <div class="top-bar-right">
                    <div class="heat-indicator <?php echo $heat_level === 'DANGER' ? 'heat-danger' : ($heat_level === 'CAUTION' ? 'heat-caution' : 'heat-safe'); ?>">
                        <i class="fas fa-thermometer-half"></i>
                        <span><?php echo $current_heat_index; ?>°C - <?php echo $heat_level; ?></span>
                    </div>
                    
                    <div class="status-indicator <?php echo $user['status'] === 'on_duty' ? 'status-online' : 'status-offline'; ?>">
                        <i class="fas fa-circle"></i>
                        <?php echo $user['status'] === 'on_duty' ? 'On Duty' : 'Off Duty'; ?>
                    </div>
                    
                    <div class="user-menu">
                        <div class="user-avatar">
                            <?php echo strtoupper(substr($user['name'], 8, 1)) . strtoupper(substr($user['name'], 13, 1)); ?>
                        </div>
                        <div class="user-info">
                            <h4><?php echo explode(' ', $user['name'])[1] . ' ' . explode(' ', $user['name'])[2]; ?></h4>
                            <p><?php echo $user['role']; ?></p>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Safety Guidelines Content -->
            <div class="safety-content">
                <!-- Current Alert Banner -->
                <div class="alert-banner alert-<?php echo strtolower($heat_level); ?>">
                    <div class="alert-icon">
                        <i class="fas <?php echo $safety_guidelines[$heat_level]['icon']; ?>"></i>
                    </div>
                    <div class="alert-content">
                        <h3>Current Heat Level: <?php echo $heat_level; ?></h3>
                        <p>Temperature: <?php echo $current_heat_index; ?>°C - Follow <?php echo $safety_guidelines[$heat_level]['level']; ?> protocols immediately</p>
                    </div>
                    <div class="alert-actions">
                        <button class="btn-primary" onclick="showCurrentGuidelines()">View Guidelines</button>
                        <a href="emergency-response.php" class="btn-danger">Emergency Response</a>
                    </div>
                </div>

                <!-- Guidelines Tabs -->
                <div class="guidelines-tabs">
                    <div class="tab-nav">
                        <?php foreach ($safety_guidelines as $key => $guideline): ?>
                        <button class="tab-btn <?php echo $key === $heat_level ? 'active' : ''; ?>" 
                                data-tab="<?php echo strtolower($key); ?>">
                            <i class="fas <?php echo $guideline['icon']; ?>"></i>
                            <?php echo $guideline['level']; ?>
                            <span class="temp-range"><?php echo $guideline['range']; ?></span>
                        </button>
                        <?php endforeach; ?>
                    </div>

                    <!-- Guidelines Content -->
                    <?php foreach ($safety_guidelines as $key => $guideline): ?>
                    <div class="tab-content <?php echo $key === $heat_level ? 'active' : ''; ?>" 
                         id="<?php echo strtolower($key); ?>-content">
                        <div class="guideline-header">
                            <div class="level-indicator level-<?php echo $guideline['color']; ?>">
                                <i class="fas <?php echo $guideline['icon']; ?>"></i>
                                <div class="level-info">
                                    <h2><?php echo $guideline['level']; ?> Level</h2>
                                    <p>Heat Index: <?php echo $guideline['range']; ?></p>
                                </div>
                            </div>
                        </div>

                        <div class="guidelines-grid">
                            <div class="guidelines-card">
                                <h3><i class="fas fa-clipboard-list"></i> Safety Guidelines</h3>
                                <ul class="guidelines-list">
                                    <?php foreach ($guideline['guidelines'] as $item): ?>
                                    <li><?php echo $item; ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>

                            <div class="guidelines-card">
                                <h3><i class="fas fa-shield-alt"></i> Safety Precautions</h3>
                                <ul class="precautions-list">
                                    <?php foreach ($guideline['precautions'] as $item): ?>
                                    <li><?php echo $item; ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Emergency Contacts -->
                <div class="emergency-section">
                    <h2><i class="fas fa-phone"></i> Emergency Contacts</h2>
                    <div class="contacts-grid">
                        <?php foreach ($emergency_contacts as $contact): ?>
                        <div class="contact-card">
                            <div class="contact-icon contact-<?php echo $contact['type']; ?>">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="contact-info">
                                <h4><?php echo $contact['name']; ?></h4>
                                <p class="contact-number"><?php echo $contact['number']; ?></p>
                            </div>
                            <button class="btn-call" onclick="callEmergency('<?php echo $contact['number']; ?>')">
                                <i class="fas fa-phone"></i> Call
                            </button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="quick-actions-safety">
                    <button class="action-btn btn-download" onclick="downloadGuidelines()">
                        <i class="fas fa-file-pdf"></i>
                        Download PDF Guidelines
                    </button>
                    <button class="action-btn btn-print" onclick="printGuidelines()">
                        <i class="fas fa-print"></i>
                        Print Guidelines
                    </button>
                    <a href="emergency-response.php" class="action-btn btn-emergency">
                        <i class="fas fa-ambulance"></i>
                        Emergency Response
                    </a>
                    <a href="heat-monitoring.php" class="action-btn btn-monitor">
                        <i class="fas fa-thermometer-half"></i>
                        Heat Monitoring
                    </a>
                </div>
            </div>
        </main>
    </div>

    <script src="assets/js/dashboard.js"></script>
    <script src="assets/js/safety-guidelines.js"></script>
     <?php include 'main-footer.php'; ?>
</body>
</html>